<?php

return apply_filters( 'ninja_forms_available_actions', array(

    'mailchimp'             => array(
        'name'              => 'mailchimp',
        'nicename'          => 'MailChimp',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/mail-chimp/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=MailChimp',
        'plugin_path'       => 'ninja-forms-mail-chimp/ninja-forms-mail-chimp.php',
        'modal_content'     => '<div class="available-action-modal">
                                    <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/mail-chimp.png"/>
                                    <p>In order to use this action, you need MailChimp for Ninja Forms.</p>
                                    <p>The MailChimp extension allows you to quickly create newsletter signup forms for your MailChimp account using the power and flexibility that Ninja Forms provides.</p>
                                    <div class="actions">
                                        <a target="_blank" href="https://ninjaforms.com/extensions/mail-chimp/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=MailChimp" title="MailChimp" class="primary nf-button">Learn More</a>
                                    </div>
                                </div>',
    ),

    'zapier'                => array(
        'name'              => 'zapier',
        'nicename'          => 'Zapier',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/zapier/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Zapier',
        'plugin_path'       => 'ninja-forms-zapier/ninja-forms-zapier.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/zapier.png"/>
                                <p>In order to use this action, you need Zapier for Ninja Forms.</p>
                                <p>Zapier is the perfect ‘middle-man’ solution for connecting WordPress to almost any service that does not yet have an official integration. Simply install and activate this extension, and your WordPress forms become the bridge between your website and Zapier. From there, they connect you to the service of your choice.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/zapier/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Zapier" title="Zapier" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'file_uploads'          => array(
        'name'              => 'file_uploads',
        'nicename'          => 'File Uploads',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/file-uploads/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=File+Uploads',
        'plugin_path'       => 'ninja-forms-uploads/file-uploads.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/file-uploads.png"/>
                                <p>In order to use this action, you need File Uploads for Ninja Forms.</p>
                                <p>Add file upload fields to save files to your server or send them to <strong>Dropbox</strong> or <strong>Amazon S3</strong> securely. The ability to collect data from your visitors is an important tool for any site owner. Sometimes the information you need comes in the form of images, videos, or documents like PDFs, Word or Excel files, etc.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/file-uploads/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=File+Uploads" title="File Uploads" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'createposts'           => array(
        'name'              => 'createposts',
        'nicename:'         => 'Front-End Posting',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/front-end-posting/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Front-End+Posting',
        'plugin_path'       => 'ninja-forms-post-creation/ninja-forms-post-creation.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/front-end-posting.png"/>
                                <p>In order to use this action, you need Front-End Posting for Ninja Forms.</p>
                                <p>Front-End Posting gives you the power of the WordPress post editor on any publicly viewable page you choose. You can allow users the ability to create content and have it assigned to any publicly available built-in or custom post type, taxonomy, and custom meta field.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/front-end-posting/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Front-End+Posting" title="Front-End Posting" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'trello'                => array(
        'name'              => 'trello',
        'nicename'          => 'Trello',
        'image'             => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAr0AAABkCAMAAAC8VHgkAAABgFBMVEX94Lz9///30aZrqtJnNhkFBQb+7dSzi2pNmcx3Syvqs4JulKzbsYgZRno4GgpVc4X948EqLDFqb3X+6s1HTlZaotHp9/7/8tmUbk4TUYv0zqT627W0rq31sSf73bohMWXGmG0scalwhpVaKRHyxJSodU3zyZ7S7vzlxaXo18Xju5JXk7rQycroqHOTVSXxxppJZXfXxbR3QiDpwpmCr8yHTSEKEC+HUSy7o4tMKBKAkJ0aK1N1aVPm5uc0OTwnZp21g1r/++XUqIBRV1+ARh/Iu7CFWTjn07aee2KYlKSbXS1TIw395sYdPG0/HAvwwmODo7hGIg81gLo+NSutlIM/jcdbRjBeMBb21a7lzrMgIiScgnGvonLaxJ3z6eBpXEj12bjuvIz4zJ0qICD/96n61q2SXjb42LNgY2jxwJCin6BvPR1dgZgZEw+nZjBxnrsUID3uv5BAQEne3NKgvc3p4Nb14ML45Mx4e4Ofgjibp5Hu4tOOaiPw7u0eXZVNoNWSmJ3/AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QIcAw8uKMt2mQAAAZdJREFUeNrt3DEOgkAURVGMe6CnYgOuhIT1zNZtiRIJoAMPz20/1csJ5TQ3KbXGBKJXoleiV/RK9Er0SvSKXoleiV7Rq5WNm7Mdval2AaY32i6+9CbjxZfeZL340ntEw5eyJL300qv6evGll156RS+9f6a3LNBuP95NSe+Beueu/QJPeuk9hd52A+7lu+itoXfbnV56c/UWeumll17RSy+99NJLr+ill17RSy+99NJLr+ill1566aWXXtFLL72il1566aWXXtFLL72il1566aWXXnpFL7300ksvvaL3lHpHeumN1es1EnrppVe/1Dv7wYNeeiP0vn1TvN9Lb5Ber0/TS6/opZdeeumll17RSy+9opdeeumll17RSy+9opdeeumll156RS+99NJL7xX03umlN0DvsO/XSy+99esm9S+3sVuRKek9VO+uTEkvvfSKXnrppZdeekUvvfSKXnrppZfeS/A1JL2xeu1IbyxfK9Iby9eG9Mb6NSC9oleiV6JXolf0SvRK9IpeE4heiV6JXtEr0SvRK016AkbKn4/DmuepAAAAAElFTkSuQmCC',
        'link'              => 'https://ninjaforms.com/extensions/trello/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Trello',
        'plugin_path'       => 'ninja-forms-trello/ninja-forms-trello.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/trello.png"/>
                                <p>In order to use this action, you need Trello for Ninja Forms.</p>
                                <p>This extension allows you to create Trello cards from you Ninja Forms submissions. You can control the card name and description from your form inputs, assign members to the card by default, set the card labels and its position. You can also set form inputs to be links attached to the cards.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/trello/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Trello" title="Trello" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'slack'                 => array(
        'name'              => 'slack',
        'nicename'          => 'Slack',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/slack/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Slack',
        'plugin_path'       => 'ninja-forms-slack/ninja-forms-slack.php',
        'modal_content'     => '<div class="available-action-modal">
                                    <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/slack.png"/>
                                    <p>In order to use this action, you need Emma for Ninja Forms.</p>
                                    <p>Add users to Slack teams and send form submission data to a Slack channel using Ninja Forms.</p>
                                    <div class="actions">
                                        <a target="_blank" href="https://ninjaforms.com/extensions/slack/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Slack" title="Slack" class="primary nf-button">Learn More</a>
                                    </div>
                                </div>',
    ),

    'webhooks'              => array(
        'name'              => 'webhooks',
        'nicename'          => 'WebHooks',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/webhooks/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebHooks',
        'plugin_path'       => 'ninja-forms-webhooks/ninja-forms-webhooks.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/webhooks.png"/>
                                <p>In order to use this action, you need WebHooks for Ninja Forms.</p>
                                <p>Do you need to integrate your form with several different web services? Maybe you’d like to subscribe a user to a Feedblitz email list, or populate a remote CRM with your user’s submitted data. The Webhooks extension allows you to send form data to a remote URL using either a GET or POST request.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/webhooks/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebHooks" title="WebHooks" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'campaignmonitor'       => array(
        'name'              => 'campaignmonitor',
        'nicename'          => 'Campaign Monitor',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/campaign-monitor/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Campaign+Monitor',
        'plugin_path'       => 'ninja-forms-campaign-monitor/ninja-forms-campaign-monitor.php',
        'modal_content'     => '<div class="available-action-modal">
                                    <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/campaign-monitor.png"/>
                                    <p>In order to use this action, you need Campaign Monitor for Ninja Forms.</p>
                                    <p>The Campaign Monitor extension allows you to quickly create newsletter signup forms for your Campaign Monitor account. Create an unlimited number of subscribe forms and begin growing your mailing lists.</p>
                                    <div class="actions">
                                        <a target="_blank" href="https://ninjaforms.com/extensions/campaign-monitor/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Campaign+Monitor" title="Campaign Monitor" class="primary nf-button">Learn More</a>
                                    </div>
                                </div>',
    ),

    'constantcontact'       => array(
        'name'              => 'constantcontact',
        'nicename'          => 'Constant Contact',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/constant-contact/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Constant+Contact',
        'plugin_path'       => 'ninja-forms-constant-contact/ninja-forms-constant-contact.php',
        'modal_content'     => '<div class="available-action-modal">
                                    <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/constant-contact.png"/>
                                    <p>In order to use this action, you need Constant Contact for Ninja Forms.</p>
                                    <p>The Constant Contact extension allows you to quickly create newsletter signup forms for your Constant Contact account. Create an unlimited number of subscribe forms and grow your mailing lists.</p>
                                    <div class="actions">
                                        <a target="_blank" href="https://ninjaforms.com/extensions/constant-contact/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Constant+Contact" title="Constant Contact" class="primary nf-button">Learn More</a>
                                    </div>
                                </div>',
    ),

    'aweber'                => array(
        'name'              => 'aweber',
        'nicename'          => 'AWeber',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/aweber/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=AWeber',
        'plugin_path'       => 'ninja-forms-aweber/ninja-forms-aweber.php',
        'modal_content'     => '<div class="available-action-modal">
                                    <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/aweber.png"/>
                                    <p>In order to use this action, you need AWeber for Ninja Forms.</p>
                                    <p>The AWeber extension allows you to quickly create newsletter signup forms for your AWeber account. Create an unlimited number of subscribe forms and grow your mailing lists.</p>
                                    <div class="actions">
                                        <a target="_blank" href="https://ninjaforms.com/extensions/aweber/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=AWeber" title="AWeber" class="primary nf-button">Learn More</a>
                                    </div>
                                </div>',
    ),

    'emma'                  => array(
        'name'              => 'emma',
        'nicename:'         => 'Emma',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/emma/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Emma',
        'plugin_path'       => '',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/emma.png"/>
                                <p>In order to use this action, you need Emma for Ninja Forms.</p>
                                <p>The Emma extension allows you to quickly create newsletter signup forms for your Emma account. Create an unlimited number of subscribe forms and grow your mailing lists.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/emma/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Emma" title="Emma" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'webmerge'              => array(
        'name'              => 'webmerge',
        'nicename'          => 'WebMerge',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/webmerge/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebMerge',
        'plugin_path'       => 'ninja-forms-webmerge/ninja-forms-webmerge.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/webmerge.png"/>
                                <p>In order to use this action, you need WebMerge for Ninja Forms.</p>
                                <p>With the WebMerge extension for Ninja Forms, you can send form data directly to the awesome <a href="https://webmerge.me" target="_blank">webmerge.me</a> service. This lets you easily populate PDFs, Excel spreadsheets, Word docs, or PowerPoint presentations.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/webmerge/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebMerge" title="WebMerge" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'twilio_sms'            => array(
        'name'              => 'twilio_sms',
        'nicename'          => 'Twilio SMS',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/twilio-sms/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Twilio+SMS',
        'plugin_path'       => 'ninja-forms-twilio/ninja-forms-twilio.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/twilio-sms.png"/>
                                <p>In order to use this action, you need Twilio SMS for Ninja Forms.</p>
                                <p>Send an SMS when someone submits your form via Twilio. SMS is a powerful way to send notifications to yourself or to your customers. Unlike other types of notifications,  90% of SMS are read within the first three minutes of delivery and have an open rate approaching 100%. </p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/twilio-sms/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Twilio+SMS" title="Twilio SMS" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'email_octopus'         => array(
        'name'              => 'email_octopus',
        'nicename'          => 'EmailOctopus',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/emailoctopus/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=EmailOctopus',
        'plugin_path'       => 'ninja-forms-emailoctopus/ninja-forms-emailoctopus.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/emailoctopus.png"/>
                                <p>In order to use this action, you need EmailOctopus for Ninja Forms.</p>
                                <p>Automation, integration, analytics… EmailOctopus is the email management solution that fills every need, and it’s now available for WordPress! More than a simple email marketing tool, discover a new way to manage every aspect of your email strategy from marketing campaigns to automated employee onboarding. <strong>Save time, save money, be an email rockstar!</strong></p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/emailoctopus/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=EmailOctopus" title="EmailOctopus" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'stripe'                => array(
        'name'              => 'stripe',
        'nicename'          => 'Stripe',
        'image'             => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAr0AAABkCAIAAAAE6B9BAAAACXBIWXMAAAsTAAALEwEAmpwYAAAE4ElEQVR4nO3d3YtUZRzA8Tm7M4vuIr6UmwoRQf9A0KutKQV1IwS9Ikk33YgaWZubZpEQppaSpWV4U95kJFImUSCEllYXEhTdhBBFsCtY4rqOu+u2c7rYBV9QeWbnuDNzns/namBmHn43M3w55znnJGmaFgAAAhTrPQAA0DR0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAAKF0AwAQSjcAlxg+nw4OVgaH0kJaqKTpDbOKbaWkpaXeYwGNQTdA7H48dm73ntPhn5/TWVz34uxSKbl+IwENK0nTtN4zAHVQqRSWr+6tcZFnnpox/672TOYBmoJugBgt6661GC724dZ5Ga4GNDLnKSAuu3af+vnXoXpPATQr3QARWdHTOzpa7yGAZqYbIBYre/pEA1Aj3QBROHSk/N+ozUxArXQDROHTz/vrPQKQB7oB8m9FT1+9RwByQjdA/o06QwFkRDdAzn33Q7neIwD5oRsg5z7ZZ2cDkBndAFxw261tL6288YpvHTpStrkS0A3AuDtvn/rs0plXe3dRV8eiro6x15u2nfzz75HJmgtoILoBGHeNaLjMmlWzx15k+5wLoPHpBmDiPNEKYqMbgHHLunt1AHBtugG4QDoA16YbgEss6+6dOqXlnQ1z6j0I0IiSNHUjOcizWrYuLn542uKHpmU4DNDsdAPk3JmBSs/6EzUusvTJGV13t2cyD9DUdAPkX1ZXSyZJYecWux8garoB8q98rtL9Wq2HHC62c8u8JMlwPaBp6AaIwnNr+kZGsvyxl4rJ9s1zM1wQaAq6AWJxPe7t6KJNiI1ugIisfv3EwNlKtms6ZwFR0Q0Ql8Gh9IV1fdmu6agDxEM3QIw2bjv5V6YPtJQOEAndAPH66uDAgW8GMllq/cudczrdfxbyTzdA7NK0sHx1b+3/BA45QAx0AzBu+Hz6/NqJb33QDRAD3QBcbuv7/xz/43y133r68RkL7nUvasg53QBc2YqevtHRKv4f3IUaYqAbgKv66di5j/ecDv+8UxWQe/Y/Q859+335gQUdE/vuPXe0V9UNQO7pBsi5L78+89kX/U88Mv3B+ydSD62tSVVnK4B80w0Qhb37+/fu7y+Vku2bqnsYlWgALqYbICIjI+nY060W3tex5NHp9R4HaD66AWJ0+Gj58NHy2Oslj01fOP8KpzCqfQjWLTeXshkOaGCup4CcW/VK39DwZPzM39s4t63NkzEh5xxvALIhGiAGugHIwJQpogGioBuADGzbUN1lGkCT0g1ArWbNbK33CMAk0Q1Ard589aZ6jwBMEt0A1MQzKSAqugGYONEAsdENwEQUi8mOzfZCQnTc9wnyb9+BMwcPnc1wwR1vzS22uvASYqQbICI7Pzr1y29DtazwwdvzWlqyGgdoProBYlSpFN7d9e/vx4dDPjxrZusbaztbHWAAdAMAEM6+SAAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAELpBgAglG4AAEL9D+jINElOan50AAAAAElFTkSuQmCC',
        'link'              => 'https://ninjaforms.com/extensions/stripe/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Stripe',
        'plugin_path'       => 'ninja-forms-stripe/ninja-forms-stripe.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/stripe.png"/>
                                <p>In order to use this action, you need Stripe for Ninja Forms.</p>
                                <p>The Stripe extension allows you to <strong>accept credit card payments</strong> directly from your WordPress website using the secure Stripe Checkout process. Customers never leave your site, instead completing their payments from the customizable Stripe Checkout modal window.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/stripe/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Stripe" title="Stripe" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'elavon'                => array(
        'name'              => 'elavon',
        'nicename'          => 'Elavon',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/elavon/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Elavon',
        'plugin_path'       => 'ninja-forms-elavon-payment-gateway/ninja-forms-elavon-payment-gateway.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/elavon.png"/>
                                <p>In order to use this action, you need Elavon for Ninja Forms.</p>
                                <p>With the Ninja Forms Elavon extension, you can connect your WordPress website directly to your merchant bank account and process credit card payments directly from your site.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/elavon/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Elavon" title="Elavon" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'pipelinedeals-crm'      => array(
        'name'              => 'pipelinedeals-crm',
        'nicename'          => 'PipelineDeals CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/pipelinedeals-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=PiplineDeals+CRM',
        'plugin_path'       => 'ninja-forms-pipeline-deals-crm/ninja-forms-pipeline-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/pipelinedeals-crm.png"/>
                                <p>In order to use this action, you need PipelineDeals CRM for Ninja Forms.</p>
                                <p>Sick of transferring customer data manually between your website and PipelineDeals? Tired of maintaining an unstable custom integration? You can now connect your website directly to PipelineDeals through Ninja Forms with this fully automated solution!</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/pipelinedeals-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=PiplineDeals+CRM" title="PipelineDeals CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'active-campaign'       => array(
        'name'              => 'active-campaign',
        'nicename'          => 'Active Campaign',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/active-campaign/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Active+Campaign',
        'plugin_path'       => 'ninja-forms-active-campaign/ninja-forms-active-campaign.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/active-campaign.png"/>
                                <p>In order to use this action, you need Active Campaign for Ninja Forms.</p>
                                <p>Active Campaign shines for sales teams that require insightful, intelligent customer relationship management. There’s no reason your integration should deliver any less. Integrate today and combine effortless, intelligent marketing automation with your WordPress website!</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/active-campaign/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Active+Campaign" title="Active Campaign" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'insightly-crm'         => array(
        'name'              => 'insightly-crm',
        'nicename'          => 'Insightly CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/insightly-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Insightly+CRM',
        'plugin_path'       => 'ninja-forms-insightly-crm/ninja-forms-insightly-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/insightly-crm.png"/>
                                <p>In order to use this action, you need Insightly CRM for Ninja Forms.</p>
                                <p>The Insightly CRM extension for Ninja Forms enables you to send your form submission data directly into your Insightly CRM account, managing your sales leads effectively.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/insightly-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Insightly+CRM" title="Insightly CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'user-management'       => array(
        'name'              => 'user-management',
        'nicename'          => 'User Management',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/user-management/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=User+Management',
        'plugin_path'       => 'ninja-forms-user-management/ninja-forms-user-management.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/user-management.png"/>
                                <p>In order to use this action, you need User Management for Ninja Forms.</p>
                                <p>With User Management for Ninja Forms, you can:<ul><li>Register new users</li><li>Login registered users</li><li>Allow users to update their existing profiles</li></p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/user-management/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=User+Management" title="User Management" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'salesforce-crm'        => array(
        'name'              => 'salesforce-crm',
        'nicename'          => 'Salesforce CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/salesforce-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Salesforce+CRM',
        'plugin_path'       => 'ninja-forms-salesforce-crm/ninja-forms-salesforce-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/salesforce-crm.png"/>
                                <p>In order to use this action, you need Salesforce CRM for Ninja Forms.</p>
                                <p>When the world’s most used CMS and the industry leading CRM come together, great things are bound to happen for your organization. WordPress and Salesforce is an integration that you need working for you!</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/salesforce-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Salesforce+CRM" title="Salesforce CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'capsule-crm'           => array(
        'name'              => 'capsule-crm',
        'nicename'          => 'Capsule CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/capsule-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Capsule+CRM',
        'plugin_path'       => 'ninja-forms-capsule-crm/ninja-forms-capsule-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/capsule-crm.png"/>
                                <p>In order to use this action, you need Capsule CRM for Ninja Forms.</p>
                                <p>Connecting your WordPress website to your CRM account shouldn’t be a time sink for your team, but it too often can be. Take that pain away with effortless integration between WordPress and your CRM with Ninja Forms’ official Capsule CRM addon!</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/capsule-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Capsule+CRM" title="Capsule CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'recurly'               => array(
        'name'              => 'recurly',
        'nicename'          => 'Recurly',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/recurly/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Recurly',
        'plugin_path'       => 'ninja-forms-recurly/ninja-forms-recurly.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/recurly.png"/>
                                <p>In order to use this action, you need Recurly for Ninja Forms.</p>
                                <p>Recurly delivers agile enterprise-class subscription management to thousands of businesses worldwide. Together with Ninja Forms, any form on any page of your site can now become an avenue to introduce your customers to the subscription management umbrella of Recurly.</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/recurly/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Recurly" title="Recurly" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'highrise-crm'          => array(
        'name'              => 'highrise-crm',
        'nicename'          => 'Highrise CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/highrise-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Highrise+CRM',
        'plugin_path'       => 'ninja-forms-highrise-crm/ninja-forms-highrise-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/highrise-crm.png"/>
                                <p>In order to use this action, you need Highrise CRM for Ninja Forms.</p>
                                <p></p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/highrise-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Highrise+CRM" title="Highrise CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),

    'onepage-crm'           => array(
        'name'              => 'onepage-crm',
        'nicename'          => 'OnePage CRM',
        'image'             => 'data:image/png;base64,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',
        'link'              => 'https://ninjaforms.com/extensions/onepage-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=OnePage+CRM',
        'plugin_path'       => 'ninja-forms-onepagecrm/ninja-forms-onepage-crm.php',
        'modal_content'     => '<div class="available-action-modal">
                                <img src="' . Ninja_Forms::$url . 'assets/img/add-ons/onepage-crm.png"/>
                                <p>In order to use this action, you need OnePage CRM for Ninja Forms.</p>
                                <p>OnePage CRM is designed to keep your sales team focused on sales instead of navigating complex software. Ninja Forms’ official integration has been built with that ideal in mind and delivers in kind!</p>
                                <div class="actions">
                                    <a target="_blank" href="https://ninjaforms.com/extensions/onepage-crm/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=OnePage+CRM" title="OnePage CRM" class="primary nf-button">Learn More</a>
                                </div>
                            </div>',
    ),
) );